
// BIBEXIgnore.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPBEXIgnore.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIBEXIgnore.h"
#endif
#import "BIAppVersioning.h"


/*!
    @class       BIBEXIgnore
    @abstract    BIBEXIgnore is a simple entity which stores information about which objects should be ignored and not imported when importing a BEX file.
    @discussion  When importing a BEX file, we search to see if a BEXIgnore exists for a particular foreign entity.  If one does, we simply skip it in the import process.  The reason we have this, is that people may export things in a BEX but they don't want them anymore, ie. they have deleted the entry in Billings as they didn't have a use for it any more.  So when we import from a BEX, we don't want to re-import what they have deleted, so we have a bexignore which tells us that, and we skip it.
*/


@interface BIBEXIgnore : BL_SUPER_CLASSNAME_MUNGE(BEXIgnore) 
{
}

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;


@end
